import numpy as np
import matplotlib.pyplot as plt

step = 0.25
klim = 3
S1 = 0.9
S2 = 0.95
S3 = 0.99


kdelta = np.arange(-klim, klim+step, step)
wdeltac1 = abs((2/S1)*np.arcsin(S1*np.sin(kdelta/2)))
wdeltac2 = abs((2/S2)*np.arcsin(S2*np.sin(kdelta/2)))
wdeltac3 = abs((2/S3)*np.arcsin(S3*np.sin(kdelta/2)))


plt.rcParams.update({'font.size': 14.5})
plt.plot(kdelta, abs(kdelta), label="analytical")
plt.plot(kdelta, wdeltac1, label="S=0.9")
plt.plot(kdelta, wdeltac2, label="S=0.95")
plt.plot(kdelta, wdeltac3, label="S=0.99")
plt.xlabel("$k_x\Delta_x$")
plt.ylabel("$\omega\Delta_x/c$")
plt.legend()
plt.gcf().set_size_inches(6.4,4.8)
plt.ylim([0,3.1])
plt.tight_layout()
plt.savefig("Images/N_dispersion_1D.png", dpi=100)
plt.show()
